<?php
/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function elevate_body_classes( $classes ) {
  // Adds a class of hfeed to non-singular pages.
  if ( ! is_singular() ) {
    $classes[] = 'hfeed';
  }

  return $classes;
}
add_filter( 'body_class', 'elevate_body_classes' );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function elevate_pingback_header() {
  if ( is_singular() && pings_open() ) {
    echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
  }
}

add_action( 'wp_head', 'elevate_pingback_header' );
/**  kses_allowed_html */
function elevate_prefix_kses_allowed_html($tags, $context) {
  switch($context) {
    case 'elevate': 
      $tags = array( 
        'a' => array('href' => array()),
        'b' => array()
      );
      return $tags;
    default: 
      return $tags;
  }
}
add_filter( 'wp_kses_allowed_html', 'elevate_prefix_kses_allowed_html', 10, 2);

/*
Register Fonts theme google font
*/
function elevate_studio_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'elevate' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Archivo:300;400;500;600;700;|Titillium Web:400;600;700' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}


function elevate_studio_scripts() {
    wp_enqueue_style( 'studio-fonts', elevate_studio_fonts_url(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'elevate_studio_scripts' );

//Favicon Icon
function elevate_site_icon() {
 if ( ! ( function_exists( 'has_site_icon' ) && has_site_icon() ) ) {     
    global $elevate_option;
     
    if(!empty($elevate_option['rs_favicon']['url']))
    {?>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo esc_url(($elevate_option['rs_favicon']['url'])); ?>"> 
  <?php 
    }
  }
}
add_filter('wp_head', 'elevate_site_icon');


//excerpt for specific section
function elevate_wpex_get_excerpt( $args = array() ) {
  // Defaults
  $defaults = array(
    'post'            => '',
    'length'          => 48,
    'readmore'        => false,
    'readmore_text'   => esc_html__( 'read more', 'elevate' ),
    'readmore_after'  => '',
    'custom_excerpts' => true,
    'disable_more'    => false,
  );
  // Apply filters
  $defaults = apply_filters( 'elevate_wpex_get_excerpt_defaults', $defaults );
  // Parse args
  $args = wp_parse_args( $args, $defaults );
  // Apply filters to args
  $args = apply_filters( 'elevate_wpex_get_excerpt_args', $defaults );
  // Extract
  extract( $args );
  // Get global post data
  if ( ! $post ) {
    global $post;
  }

  $post_id = $post->ID;
  if ( $custom_excerpts && has_excerpt( $post_id ) ) {
    $output = $post->post_excerpt;
  } 
  else { 
    $readmore_link = '<a href="' . get_permalink( $post_id ) . '" class="readmore">' . $readmore_text . $readmore_after . '</a>';    
    if ( ! $disable_more && strpos( $post->post_content, '<!--more-->' ) ) {
      $output = apply_filters( 'the_content', get_the_content( $readmore_text . $readmore_after ) );
    }    
    else {     
      $output = wp_trim_words( strip_shortcodes( $post->post_content ), $length );      
      if ( $readmore ) {
        $output .= apply_filters( 'elevate_wpex_readmore_link', $readmore_link );
      }
    }
  }
  // Apply filters and echo
  return apply_filters( 'elevate_wpex_get_excerpt', $output );
}

//Demo content file include here

function elevate_import_files() {
  return array(
    array(
      'import_file_name'           => 'Elevate Default Demo',
      'categories'                 => array( 'Main Demo' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/default/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/default/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/01.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate',     
      
    ),
    array(
      'import_file_name'           => 'Elevate Construction',
      'categories'                 => array( 'Construction' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/default/elevate-content-2.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/default/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/02.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/home-two/',     
      
    ), 
    array(
      'import_file_name'           => 'Renovation',
      'categories'                 => array( 'Renovation' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/renovation/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/renovation/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/03.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/renovation/',     
      
    ), 

    //factory
    array(
      'import_file_name'           => 'Factory',
      'categories'                 => array( 'Factory' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/factory/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/factory/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/04.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/factory/',     
      
    ), 
    //building
    array(
      'import_file_name'           => 'Building',
      'categories'                 => array( 'Building' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/building/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/building/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/05.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/building/',     
      
    ), 
    //architecute
    array(
      'import_file_name'           => 'Architecure',
      'categories'                 => array( 'Architecture' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/architecture/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/architecture/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/06.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/architecture/',     
      
    ), 
    //handyman
    array(
      'import_file_name'           => 'Handyman',
      'categories'                 => array( 'Handyman' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/handyman/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/handyman/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/08.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/handyman/',     
      
    ),
    
     //engineering
     array(
      'import_file_name'           => 'Engennering',
      'categories'                 => array( 'Engennering' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/engineer/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/engineer/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/07.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/handyman/',     
      
    ), 

    //industrial
    array(
      'import_file_name'           => 'Industrial',
      'categories'                 => array( 'Industrial' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/industrial/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/industrial/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/09.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/industrial/',     
      
    ), 

    //solar
    array(
      'import_file_name'           => 'Solar',
      'categories'                 => array( 'Solar' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/solar/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/solar/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/elevate/wp-content/uploads/2023/04/home-10.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/solar/',     
      
    ), 

     //rtl
     array(
      'import_file_name'           => 'RTL Demo',
      'categories'                 => array( 'RTL' ),
      'import_file_url'            => 'https://reactheme.com/products/demo-data/elevate/rtl/elevate-content.xml',
             
      'import_redux'               => array(
        array(
          'file_url'    => 'https://reactheme.com/products/demo-data/elevate/rtl/elevate-options.json',
          'option_name' => 'elevate_option',
        ),
      ),

      'import_preview_image_url'   => 'https://reactheme.com/products/demo-data/elevate/rtl/rtl.jpg',
     'import_notice'              => esc_html__( 'Caution: For importing demo data please click on "Import Demo Data" button. During demo data installation please do not refresh the page.', 'elevate' ),
      'preview_url'                => 'https://reactheme.com/products/wordpress/elevate/rtl/',     
      
    ), 

    
  );
}

add_filter( 'pt-ocdi/import_files', 'elevate_import_files' );

function elevate_after_import_setup($selected_import) {
  // Assign menus to their locations.
	$main_menu     = get_term_by( 'name', 'Primary Menu', 'nav_menu' );
  $menu_single     = get_term_by( 'name', 'Onepage Menu', 'nav_menu' );
	set_theme_mod( 'nav_menu_locations', array(
      'menu-1' => $main_menu->term_id, 
      'menu-2' => $menu_single->term_id,      
    )
  );
  if ( 'Elevate Default Demo' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Main Construction');
  }

  if ( 'Elevate Construction' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Construction Home');
  }

  if ( 'Renovation' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Renovation Home');
  }

  if ( 'Factory' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Factory Home');
  }

  if ( 'Building' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Building Home');
  }

  if ( 'Architecture' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Architecture Home');
  }
    
  if ( 'Handyman' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Handyman Home');
  }

  if ( 'Engennering' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Home');
  }

  if ( 'Industrial' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Industrial Home');
  }

  if ( 'RTL Demo' == $selected_import['import_file_name'] ) {
    $front_page_id = get_page_by_title('Main Construction');
  }
  
  $blog_page_id  = get_page_by_title( 'News & Media' );
  update_option( 'show_on_front', 'page' );
  update_option( 'page_on_front', $front_page_id->ID );
  update_option( 'page_for_posts', $blog_page_id->ID ); 

  //Import Revolution Slider
  //Import Revolution Slider
  if ( class_exists( 'RevSlider' ) ) {
    $slider_array = array(
      get_template_directory()."/inc/demo-data/sliders/slider-2.zip",   
      get_template_directory()."/inc/demo-data/sliders/Factory-Slider.zip",  
      get_template_directory()."/inc/demo-data/sliders/slider-factory-1.zip",   
      get_template_directory()."/inc/demo-data/sliders/handyman-slider-1.zip", 
      get_template_directory()."/inc/demo-data/sliders/industrial-slider.zip",   
      get_template_directory()."/inc/demo-data/sliders/rtl-slider.zip",                        
                                  
    );
    $slider = new RevSlider();
    foreach($slider_array as $filepath){
      $slider->importSliderFromPost(true,true,$filepath);  
    }
  }
  
}
add_action( 'pt-ocdi/after_import', 'elevate_after_import_setup' );

add_filter( 'use_widgets_block_editor', '__return_false' );

function elevate_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'elevate_mime_types');
update_option('elementor_disable_color_schemes', 'yes');
update_option('elementor_disable_typography_schemes', 'yes');