<div class="react-addon-services services-<?php echo esc_attr( $settings['services_style'] ); ?>">
	<div class="rts-single-service-three sal-animate" data-sal="slide-up" data-sal-delay="150" data-sal-duration="800">
		<?php if( !empty($settings['selected_icon']) || !empty($settings['selected_image']['url'])){ ?>
			<a class="thumbnail-area">
				<?php if(!empty($settings['selected_icon'])) : ?>
					<?php \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] ); ?>
				<?php endif; ?>
				<?php if(!empty($settings['selected_image'])) :?>
						<img src="<?php echo esc_url( $settings['selected_image']['url'] );?>" alt="image"/>
				<?php endif;?>			
			</a>
		<?php }?>	
		
		<div class="content-area">
			<?php if( !empty($settings['title']) ): ?>
				<a href="<?php echo esc_url($settings['title_link']);?>">
					<h5 class="title"><?php echo esc_html($settings['title']); ?></h5>
				</a>	
			<?php endif; ?>
			
			<?php if( !empty($settings['text']) ): ?>
				<p class="disc"><?php echo wp_kses_post($settings['text']);?></p>
			<?php endif; ?>

			<?php if(!empty($settings['services_btn_text'])) : ?>
				<a href="<?php echo esc_url($settings['services_btn_link']);?>" class="read-more-btn">
					<?php echo esc_html($settings['services_btn_text']);?> 
					<i class="<?php echo esc_html($settings['services_btn_icon']['value']); ?>"></i>
				</a>
			<?php endif; ?>
		</div>
	</div>
</div>