<?php $gray_scale = $settings['show_graycale']; ?>
<div class="react-addon-services 
services-<?php echo esc_attr( $settings['services_style'] ); ?> gray_<?php echo $gray_scale;?>">
	<div class="rts-single-service-inner">
		<div class="services-image">
			<?php if(!empty($settings['selected_image'])) :				
				$link_open = $settings['services_btn_link_open'] == 'yes' ? 'target=_blank' : '';				
			?>
				<a  href="<?php echo esc_url($settings['services_btn_link']);?>" <?php echo wp_kses_post($link_open); ?>><img src="<?php echo esc_url( $settings['selected_image']['url'] );?>" alt="image"/></a>
			<?php endif;?>
			<?php if( $settings['image_batch'] ) : ?>
				<div class="img-batch">
					<span><?php echo esc_html($settings['image_batch']);?></span>
				</div>
			<?php endif;?>
		</div>
		<div class="service-content">
			<?php if(!empty($settings['title'])){ ?>
		    	<div class="services-title">
		    		<?php if(!empty($settings['title_link'])) : 
		    			$link_open = $settings['link_open'] == 'yes' ? 'target=_blank' : '';
		    		?>					    							    			
		    		<<?php echo esc_html($settings['title_tag']);?>  <?php  echo wp_kses_post($this->print_render_attribute_string( 'title' )); ?>> <a href="<?php echo esc_url($settings['title_link']);?>" <?php echo wp_kses_post($link_open); ?> ><?php echo esc_html($settings['title']);?></a></<?php echo esc_html($settings['title_tag']);?>>
		    		<?php else: ?>
		    			<<?php echo esc_html($settings['title_tag']);?> <?php  echo wp_kses_post($this->print_render_attribute_string( 'title' )); ?>> <?php echo esc_html($settings['title']);?></<?php echo esc_html($settings['title_tag']);?>>
		    		<?php endif; ?>				    		
		    	</div>
	    	<?php } ?>	
			<?php if(!empty($settings['text'])) : ?>
	    		<p <?php  echo wp_kses_post($this->print_render_attribute_string( 'text' )); ?>> <?php echo wp_kses_post($settings['text']);?></p>	
	    	<?php endif; ?>	
			<div class="services-btn-part react-button ">
				<?php 
					$link_open = $settings['services_btn_link_open'] == 'yes' ? 'target=_blank' : '';
					$icon_position = $settings['services_btn_icon_position'] == 'before' ? 'icon-before' : 'icon-after';
				?>
				<a class="services-btn <?php echo esc_html($icon_position); ?>" href="<?php echo esc_url($settings['services_btn_link']);?>" <?php echo wp_kses_post($link_open); ?>>
				<?php if(!empty($settings['services_btn_text'])){ ?>
					<span <?php echo wp_kses_post($this->print_render_attribute_string( 'services_btn_text' )); ?>>
						<?php echo esc_html($settings['services_btn_text']);?>
					</span>
					<?php } ?>
				</a>	    		    		
			</div>
		</div>
	</div>
</div>